package com.app.yourradioapp593.utils;

import static com.app.yourradioapp593.utils.Constant.PERMISSIONS_REQUEST;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.ResultReceiver;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicBlur;
import android.util.Base64;
import android.util.Log;
import android.view.Gravity;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import androidx.activity.ComponentActivity;
import androidx.activity.EdgeToEdge;
import androidx.annotation.ColorRes;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.Insets;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentPagerAdapter;

import com.app.yourradioapp593.BuildConfig;
import com.app.yourradioapp593.Config;
import com.app.yourradioapp593.R;
import com.app.yourradioapp593.activities.ActivityWebView;
import com.app.yourradioapp593.activities.MainActivity;
import com.app.yourradioapp593.database.dao.AppDatabase;
import com.app.yourradioapp593.database.dao.DAO;
import com.app.yourradioapp593.database.dao.RadioEntity;
import com.app.yourradioapp593.database.prefs.SharedPref;
import com.app.yourradioapp593.listener.OnCompleteListener;
import com.app.yourradioapp593.listener.OnNeutralButtonListener;
import com.app.yourradioapp593.listener.OnPositiveButtonListener;
import com.app.yourradioapp593.models.Radio;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.android.material.snackbar.Snackbar;

import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@SuppressWarnings("deprecation")
public class Tools {

    public static final String TAG = "Tools";
    Context context;
    SharedPref sharedPref;
    private BottomSheetDialog mBottomSheetDialog;
    private boolean flagReadLater;
    DAO db;

    public Tools(Context context) {
        this.context = context;
        this.sharedPref = new SharedPref(context);
        this.db = AppDatabase.getDb(context).get();
    }

    public void showBottomSheetDialog(Activity activity, View parentView, Radio radio) {
        @SuppressLint("InflateParams") View view = activity.getLayoutInflater().inflate(R.layout.include_bottom_sheet, null);

        FrameLayout lytBottomSheet = view.findViewById(R.id.bottom_sheet);

        ImageView radioImage = view.findViewById(R.id.sheet_radio_image);
        TextView radioName = view.findViewById(R.id.sheet_radio_name);
        TextView radioCategory = view.findViewById(R.id.sheet_category_name);

        TextView txtFavorite = view.findViewById(R.id.txt_favorite);

        ImageView imgFavorite = view.findViewById(R.id.img_favorite);
        ImageView imgShare = view.findViewById(R.id.img_share);
        ImageView imgReport = view.findViewById(R.id.img_report);

        Glide.with(context)
                .load(sharedPref.getBaseUrl() + "/upload/" + radio.radio_image.replace(" ", "%20"))
                .placeholder(R.drawable.ic_thumbnail)
                .diskCacheStrategy(DiskCacheStrategy.ALL)
                .into(radioImage);

        radioName.setText(radio.radio_name);
        radioCategory.setText(radio.category_name);

        if (sharedPref.getIsDarkTheme()) {
            lytBottomSheet.setBackground(ContextCompat.getDrawable(activity, R.drawable.bg_rounded_dark));
            imgFavorite.setColorFilter(ContextCompat.getColor(activity, R.color.color_white));
            imgShare.setColorFilter(ContextCompat.getColor(activity, R.color.color_white));
            imgReport.setColorFilter(ContextCompat.getColor(activity, R.color.color_white));
        } else {
            lytBottomSheet.setBackground(ContextCompat.getDrawable(activity, R.drawable.bg_rounded_default));
            imgFavorite.setColorFilter(ContextCompat.getColor(activity, R.color.grey_dark));
            imgShare.setColorFilter(ContextCompat.getColor(activity, R.color.grey_dark));
            imgReport.setColorFilter(ContextCompat.getColor(activity, R.color.grey_dark));
        }

        LinearLayout btnFavorite = view.findViewById(R.id.btn_favorite);
        LinearLayout btnShare = view.findViewById(R.id.btn_share);
        LinearLayout btnReport = view.findViewById(R.id.btn_report);

        btnFavorite.setOnClickListener(v -> {
            if (Tools.isNetworkAvailable(activity)) {
                flagReadLater = db.getRadio(radio.radio_id) != null;
                if (flagReadLater) {
                    db.deleteRadio(radio.radio_id);
                    imgFavorite.setImageDrawable(ContextCompat.getDrawable(activity, R.drawable.ic_star_outline));
                    Snackbar.make(parentView, R.string.favorite_removed, Snackbar.LENGTH_SHORT).show();
                } else {
                    db.insertRadio(RadioEntity.entity(radio));
                    imgFavorite.setImageDrawable(ContextCompat.getDrawable(activity, R.drawable.ic_star_white));
                    Snackbar.make(parentView, R.string.favorite_added, Snackbar.LENGTH_SHORT).show();
                }
            }
            mBottomSheetDialog.dismiss();
        });

        btnShare.setOnClickListener(v -> {
            if (Constant.item_radio.size() > 0) {
                Intent share = new Intent(Intent.ACTION_SEND);
                share.setType("text/plain");
                share.putExtra(Intent.EXTRA_TEXT, activity.getString(R.string.share_radio_text) + " - " + Constant.item_radio.get(Constant.position).radio_name + "\n" + activity.getString(R.string.app_name) + " - http://play.google.com/store/apps/details?id=" + BuildConfig.APPLICATION_ID);
                activity.startActivity(share);
            }
            mBottomSheetDialog.dismiss();
        });

        btnReport.setOnClickListener(v -> {
            String str;
            try {
                str = activity.getPackageManager().getPackageInfo(activity.getPackageName(), 0).versionName;
                Intent intent = new Intent(Intent.ACTION_SENDTO);
                intent.setData(Uri.parse("mailto:"));
                intent.putExtra(Intent.EXTRA_EMAIL, new String[]{activity.getString(R.string.report_email)});
                intent.putExtra(Intent.EXTRA_SUBJECT, "Report " + radio.radio_name + " channel issue in " + activity.getResources().getString(R.string.app_name));
                intent.putExtra(Intent.EXTRA_TEXT, "Device OS : Android \n Device OS version : " +
                        Build.VERSION.RELEASE + "\n App Version : " + str + "\n Device Brand : " + Build.BRAND +
                        "\n Device Model : " + Build.MODEL + "\n Device Manufacturer : " + Build.MANUFACTURER + "\n" + "Message : ");
                try {
                    activity.startActivity(Intent.createChooser(intent, activity.getResources().getString(R.string.menu_report)));
                } catch (android.content.ActivityNotFoundException ex) {
                    Toast.makeText(activity.getApplicationContext(), "There are no email clients installed.", Toast.LENGTH_SHORT).show();
                }
            } catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
            mBottomSheetDialog.dismiss();
        });

        if (Config.ENABLE_RTL_MODE) {
            if (sharedPref.getIsDarkTheme()) {
                this.mBottomSheetDialog = new BottomSheetDialog(activity, R.style.SheetDialogDarkRtl);
            } else {
                this.mBottomSheetDialog = new BottomSheetDialog(activity, R.style.SheetDialogLightRtl);
            }
        } else {
            if (sharedPref.getIsDarkTheme()) {
                this.mBottomSheetDialog = new BottomSheetDialog(activity, R.style.SheetDialogDark);
            } else {
                this.mBottomSheetDialog = new BottomSheetDialog(activity, R.style.SheetDialogLight);
            }
        }
        this.mBottomSheetDialog.setContentView(view);
        mBottomSheetDialog.show();
        mBottomSheetDialog.setOnDismissListener(dialog -> mBottomSheetDialog = null);

        flagReadLater = db.getRadio(radio.radio_id) != null;
        if (flagReadLater) {
            txtFavorite.setText(activity.getString(R.string.favorite_remove));
            imgFavorite.setImageResource(R.drawable.ic_menu_favorite);
        } else {
            txtFavorite.setText(activity.getString(R.string.favorite_add));
            imgFavorite.setImageResource(R.drawable.ic_menu_favorite_outline);
        }

    }

    public static void requestPermission(Activity activity) {
        if ((ContextCompat.checkSelfPermission(activity, "android.permission.READ_PHONE_STATE") != PackageManager.PERMISSION_GRANTED)) {
            activity.requestPermissions(new String[]{"android.permission.READ_PHONE_STATE"}, PERMISSIONS_REQUEST);
        }
    }

    public static void notificationOpenHandler(Context context, Intent getIntent) {
        long unique_id = getIntent.getLongExtra("unique_id", 0);
        long post_id = getIntent.getLongExtra("post_id", 0);
        String title = getIntent.getStringExtra("title");
        String link = getIntent.getStringExtra("link");
        if (post_id == 0) {
            if (link != null && !link.equals("")) {
                if (Config.OPEN_NOTIFICATION_LINK_IN_EXTERNAL_BROWSER) {
                    context.startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse(link)));
                } else {
                    if (link.contains("play.google.com") || link.contains("?target=external")) {
                        context.startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse(link)));
                    } else {
                        Intent intent = new Intent(context, ActivityWebView.class);
                        intent.putExtra("title", title);
                        intent.putExtra("url", link);
                        context.startActivity(intent);
                    }
                }
            }
        } else {
            Intent intent = new Intent(context, MainActivity.class);
            context.startActivity(intent);
        }
        Log.d("onMessageFirebase", "unique_id: " + unique_id);
        Log.d("onMessageFirebase", "post_id: " + post_id);
        Log.d("onMessageFirebase", "title: " + title);
        Log.d("onMessageFirebase", "link: " + link);
    }

    public static void getTheme(Activity activity) {
        SharedPref sharedPref = new SharedPref(activity);
        if (sharedPref.getIsDarkTheme()) {
            activity.setTheme(R.style.AppDarkTheme);
        } else {
            if (Config.ENABLE_NEW_UI) {
                activity.setTheme(R.style.AppLightTheme);
            } else {
                activity.setTheme(R.style.AppLegacyTheme);
            }
        }
        EdgeToEdge.enable((ComponentActivity) activity);
    }

//    public static void setNavigation(Activity activity) {
//        ViewCompat.setOnApplyWindowInsetsListener(activity.findViewById(R.id.root_view), (v, insets) -> {
//            Insets systemBars = insets.getInsets(WindowInsetsCompat.Type.systemBars());
//            v.setPadding(systemBars.left, systemBars.top, systemBars.right, systemBars.bottom);
//            return insets;
//        });
//        SharedPref sharedPref = new SharedPref(activity);
//        if (sharedPref.getIsDarkTheme()) {
//            Tools.darkNavigation(activity);
//        } else {
//            Tools.lightNavigation(activity);
//        }
//        setLayoutDirection(activity);
//    }

    public static void setNavigation(Activity activity) {
        RelativeLayout rootView = activity.findViewById(R.id.root_view);
        RelativeLayout backgroundView = activity.findViewById(R.id.background_view);
        RelativeLayout navigationBarView = activity.findViewById(R.id.navigation_bar_view);

        ViewCompat.setOnApplyWindowInsetsListener(rootView, (v, insets) -> {
            Insets systemBars = insets.getInsets(WindowInsetsCompat.Type.systemBars());
            v.setPadding(systemBars.left, systemBars.top, systemBars.right, 0);
            navigationBarView.setPadding(0, 0, 0, systemBars.bottom);
            return insets;
        });
        SharedPref sharedPref = new SharedPref(activity);
        if (sharedPref.getIsDarkTheme()) {
            Tools.darkNavigation(activity);
            backgroundView.setBackgroundColor(ContextCompat.getColor(activity, R.color.color_dark_background));
            navigationBarView.setBackgroundColor(ContextCompat.getColor(activity, R.color.color_dark_bottom_navigation));
            rootView.setBackgroundColor(ContextCompat.getColor(activity, R.color.color_dark_status_bar));
            WindowCompat.getInsetsController(activity.getWindow(), activity.getWindow().getDecorView()).setAppearanceLightStatusBars(false);
            WindowCompat.getInsetsController(activity.getWindow(), activity.getWindow().getDecorView()).setAppearanceLightNavigationBars(false);
        } else {
            Tools.lightNavigation(activity);
            backgroundView.setBackgroundColor(ContextCompat.getColor(activity, R.color.color_light_background));
            navigationBarView.setBackgroundColor(ContextCompat.getColor(activity, R.color.color_light_bottom_navigation));
            if (Config.ENABLE_NEW_UI) {
                rootView.setBackgroundColor(ContextCompat.getColor(activity, R.color.color_white));
                WindowCompat.getInsetsController(activity.getWindow(), activity.getWindow().getDecorView()).setAppearanceLightStatusBars(true);
                WindowCompat.getInsetsController(activity.getWindow(), activity.getWindow().getDecorView()).setAppearanceLightNavigationBars(true);
            } else {
                rootView.setBackgroundColor(ContextCompat.getColor(activity, R.color.color_light_status_bar));
                WindowCompat.getInsetsController(activity.getWindow(), activity.getWindow().getDecorView()).setAppearanceLightStatusBars(false);
                WindowCompat.getInsetsController(activity.getWindow(), activity.getWindow().getDecorView()).setAppearanceLightNavigationBars(true);
            }
        }
        setLayoutDirection(activity);
    }

    public static void setLayoutDirection(Activity activity) {
        if (Config.ENABLE_RTL_MODE) {
            activity.getWindow().getDecorView().setLayoutDirection(View.LAYOUT_DIRECTION_RTL);
        } else {
            activity.getWindow().getDecorView().setLayoutDirection(View.LAYOUT_DIRECTION_LTR);
        }
    }

    public static void darkNavigation(Activity activity) {
        activity.getWindow().setStatusBarColor(ContextCompat.getColor(activity, R.color.color_dark_status_bar));
        WindowCompat.getInsetsController(activity.getWindow(), activity.getWindow().getDecorView()).setAppearanceLightStatusBars(false);
        WindowCompat.getInsetsController(activity.getWindow(), activity.getWindow().getDecorView()).setAppearanceLightNavigationBars(false);
        activity.getWindow().setNavigationBarColor(ContextCompat.getColor(activity, R.color.color_dark_bottom_navigation));
    }

    public static void lightNavigation(Activity activity) {
        if (Config.ENABLE_NEW_UI) {
            activity.getWindow().setStatusBarColor(ContextCompat.getColor(activity, R.color.color_white));
            WindowCompat.getInsetsController(activity.getWindow(), activity.getWindow().getDecorView()).setAppearanceLightStatusBars(true);
        } else {
            activity.getWindow().setStatusBarColor(ContextCompat.getColor(activity, R.color.color_light_status_bar));
            WindowCompat.getInsetsController(activity.getWindow(), activity.getWindow().getDecorView()).setAppearanceLightStatusBars(false);
        }
        WindowCompat.getInsetsController(activity.getWindow(), activity.getWindow().getDecorView()).setAppearanceLightNavigationBars(true);
        activity.getWindow().setNavigationBarColor(ContextCompat.getColor(activity, R.color.color_light_bottom_navigation));
    }

    public static void windowLightStatusBar(Activity activity, boolean on) {
        View view = activity.getWindow().getDecorView();
        if (on) {
            view.setSystemUiVisibility(view.getSystemUiVisibility() | View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR);
            WindowCompat.getInsetsController(activity.getWindow(), activity.getWindow().getDecorView()).setAppearanceLightStatusBars(Config.ENABLE_NEW_UI);
        } else {
            view.setSystemUiVisibility(view.getSystemUiVisibility() & ~View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR);
            WindowCompat.getInsetsController(activity.getWindow(), activity.getWindow().getDecorView()).setAppearanceLightStatusBars(false);
        }
    }

    public static void setStatusBarColor(Activity activity, View rootView, int color) {
        activity.getWindow().setStatusBarColor(color);
        rootView.setBackgroundColor(color);
//        if (Config.ENABLE_NEW_UI) {
//            rootView.setBackgroundColor(color);
//        } else {
//            rootView.setBackgroundColor(ContextCompat.getColor(activity, R.color.color_light_status_bar));
//        }
    }

    public static String decrypt(String code) {
        return decodeBase64(decodeBase64(code));
    }

    public static String decodeBase64(String code) {
        byte[] valueDecoded = Base64.decode(code.getBytes(StandardCharsets.UTF_8), Base64.DEFAULT);
        return new String(valueDecoded);
    }

    public static String milliSecondsToTimer(long milliseconds) {
        String finalTimerString = "";
        String hourString = "";
        String secondsString = "";
        String minutesString = "";

        // Convert total duration into time
        int hours = (int) (milliseconds / (1000 * 60 * 60));
        int minutes = (int) (milliseconds % (1000 * 60 * 60)) / (1000 * 60);
        int seconds = (int) ((milliseconds % (1000 * 60 * 60)) % (1000 * 60) / 1000);
        // Add hours if there
        long temp_milli = Constant.exoPlayer.getDuration();
        int temp_hour = (int) (temp_milli / (1000 * 60 * 60));
        if (temp_hour != 0) {
            hourString = hours + ":";
        }

        // Prepending 0 to seconds if it is one digit
        if (seconds < 10) {
            secondsString = "0" + seconds;
        } else {
            secondsString = "" + seconds;
        }

        // Prepending 0 to minutes if it is one digit
        if (minutes < 10) {
            minutesString = "0" + minutes;
        } else {
            minutesString = "" + minutes;
        }

        finalTimerString = hourString + minutesString + ":" + secondsString;

        // return timer string
        return finalTimerString;
    }

    public static int getProgressPercentage(long currentDuration, long totalDuration) {
        Double percentage = (double) 0;

        long currentSeconds = (int) (currentDuration / 1000);
        long totalSeconds = (int) (totalDuration / 1000);

        // calculating percentage
        percentage = (((double) currentSeconds) / totalSeconds) * 100;

        // return percentage
        return percentage.intValue();
    }

    public static long getSeekFromPercentage(int percentage, long totalDuration) {

        long currentSeconds = 0;
        long totalSeconds = (int) (totalDuration / 1000);

        // calculating percentage
        currentSeconds = (percentage * totalSeconds) / 100;

        // return percentage
        return currentSeconds * 1000;
    }

    public static int calculateTime(String duration) {
        int time = 0, min, sec, hr = 0;
        try {
            StringTokenizer st = new StringTokenizer(duration, ".");
            if (st.countTokens() == 3) {
                hr = Integer.parseInt(st.nextToken());
            }
            min = Integer.parseInt(st.nextToken());
            sec = Integer.parseInt(st.nextToken());
        } catch (Exception e) {
            StringTokenizer st = new StringTokenizer(duration, ":");
            if (st.countTokens() == 3) {
                hr = Integer.parseInt(st.nextToken());
            }
            min = Integer.parseInt(st.nextToken());
            sec = Integer.parseInt(st.nextToken());
        }
        time = ((hr * 3600) + (min * 60) + sec) * 1000;
        return time;
    }

    public long convertToMilliSeconds(String s) {

        long ms = 0;
        Pattern p;
        if (s.contains(("\\:"))) {
            p = Pattern.compile("(\\d+):(\\d+)");
        } else {
            p = Pattern.compile("(\\d+).(\\d+)");
        }
        Matcher m = p.matcher(s);
        if (m.matches()) {
            int h = Integer.parseInt(m.group(1));
            int min = Integer.parseInt(m.group(2));
            // int sec = Integer.parseInt(m.group(2));
            ms = (long) h * 60 * 60 * 1000 + min * 60 * 1000;
        }
        return ms;
    }

    public static void getPosition(Boolean isNext) {
        if (isNext) {
            if (Constant.position != Constant.item_radio.size() - 1) {
                Constant.position = Constant.position + 1;
            } else {
                Constant.position = 0;
            }
        } else {
            if (Constant.position != 0) {
                Constant.position = Constant.position - 1;
            } else {
                Constant.position = Constant.item_radio.size() - 1;
            }
        }
    }

    public static boolean isNetworkAvailable(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
        NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetworkInfo != null && activeNetworkInfo.isConnected();
    }

    public static boolean isConnect(Context context) {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager) context.getSystemService(Context.CONNECTIVITY_SERVICE);
            NetworkInfo activeNetworkInfo = connectivityManager.getActiveNetworkInfo();
            if (activeNetworkInfo != null) {
                return activeNetworkInfo.isConnected() || activeNetworkInfo.isConnectedOrConnecting();
            } else {
                return false;
            }
        } catch (Exception e) {
            return false;
        }
    }

//    public void clickListener(final int pos, final String type) {
//        onItemClickListener.onClick(pos, type);
//    }

    public interface onItemClickListener {
        void onClick(int position, String type);
    }

    public class IMMResult extends ResultReceiver {

        public int result = -1;

        public IMMResult() {
            super(null);
        }

        @Override
        public void onReceiveResult(int r, Bundle data) {
            result = r;
        }

        // poll result value for up to 500 milliseconds
        public int getResult() {
            try {
                int sleep = 0;
                while (result == -1 && sleep < 500) {
                    Thread.sleep(100);
                    sleep += 100;
                }
            } catch (InterruptedException e) {
                Log.e("IMMResult", e.getMessage());
            }
            return result;
        }
    }

    public static int getScreenWidth(Activity activity) {
        Point size = new Point();
        activity.getWindowManager().getDefaultDisplay().getSize(size);
        return size.x;
    }

    //Get response from an URL request (GET)
    public static String getDataFromUrl(String url) {
        // Making HTTP request
        Log.v("INFO", "Requesting: " + url);

        StringBuffer chaine = new StringBuffer("");
        try {
            URL urlCon = new URL(url);

            //Open a connection
            HttpURLConnection connection = (HttpURLConnection) urlCon
                    .openConnection();
            connection.setRequestProperty("User-Agent", "Your Single Radio");
            connection.setRequestMethod("GET");
            connection.setDoInput(true);
            connection.connect();

            //Handle redirecti
            int status = connection.getResponseCode();
            if ((status != HttpURLConnection.HTTP_OK)
                    && (status == HttpURLConnection.HTTP_MOVED_TEMP
                    || status == HttpURLConnection.HTTP_MOVED_PERM
                    || status == HttpURLConnection.HTTP_SEE_OTHER)) {

                // get redirect url from "location" header field
                String newUrl = connection.getHeaderField("Location");
                // get the cookie if need, for login
                String cookies = connection.getHeaderField("Set-Cookie");

                // open the new connnection again
                connection = (HttpURLConnection) new URL(newUrl).openConnection();
                connection.setRequestProperty("Cookie", cookies);
                connection.setRequestProperty("User-Agent", "Your Single Radio");
                connection.setRequestMethod("GET");
                connection.setDoInput(true);

                System.out.println("Redirect to URL : " + newUrl);
            }

            //Get the stream from the connection and read it
            InputStream inputStream = connection.getInputStream();
            BufferedReader rd = new BufferedReader(new InputStreamReader(inputStream));
            String line = "";
            while ((line = rd.readLine()) != null) {
                chaine.append(line);
            }

        } catch (IOException e) {
            // writing exception to log
        }

        return chaine.toString();
    }

    //Get JSON from an url and parse it to a JSON Object.
    public static JSONObject getJSONObjectFromUrl(String url) {
        String data = getDataFromUrl(url);

        try {
            return new JSONObject(data);
        } catch (Exception e) {
            Log.e("INFO", "Error parsing JSON. Printing stacktrace now");
        }

        return null;
    }

    public static String getUserAgent() {
        return Constant.USER_AGENT;
    }

    public static String getLegacyUserAgent() {

        StringBuilder result = new StringBuilder(64);
        result.append("Dalvik/");
        result.append(System.getProperty("java.vm.version"));
        result.append(" (Linux; U; Android ");

        String version = Build.VERSION.RELEASE;
        result.append(version.length() > 0 ? version : "1.0");

        if ("REL".equals(Build.VERSION.CODENAME)) {
            String model = Build.MODEL;
            if (model.length() > 0) {
                result.append("; ");
                result.append(model);
            }
        }

        String id = Build.ID;

        if (id.length() > 0) {
            result.append(" Build/");
            result.append(id);
        }

        result.append(")");
        return result.toString();
    }

    public static Bitmap blurImage(Activity activity, Bitmap bitmap) {
        try {
            RenderScript rsScript = RenderScript.create(activity);
            Allocation allocation = Allocation.createFromBitmap(rsScript, bitmap);

            ScriptIntrinsicBlur blur = ScriptIntrinsicBlur.create(rsScript, Element.U8_4(rsScript));
            blur.setRadius(10);
            blur.setInput(allocation);

            Bitmap result = Bitmap.createBitmap(bitmap.getWidth(), bitmap.getHeight(), Bitmap.Config.ARGB_8888);
            Allocation outAlloc = Allocation.createFromBitmap(rsScript, result);

            blur.forEach(outAlloc);
            outAlloc.copyTo(result);

            rsScript.destroy();
            return result;
        } catch (Exception e) {
            return bitmap;
        }

    }

    public static void setNativeAdStyle(Context context, LinearLayout nativeAdView, String style) {
        switch (style) {
            case "small":
                nativeAdView.addView(View.inflate(context, com.solodroidx.ads.R.layout.view_native_ad_radio, null));
                break;
            case "medium":
                nativeAdView.addView(View.inflate(context, com.solodroidx.ads.R.layout.view_native_ad_news, null));
                break;
            default:
                nativeAdView.addView(View.inflate(context, com.solodroidx.ads.R.layout.view_native_ad_medium, null));
                break;
        }
    }

    public static String nativeAdStyleFormatter(String style) {
        return switch (style) {
            case "small" -> "radio";
            case "medium" -> "news";
            case "large" -> "medium";
            default -> "default";
        };
    }

    public static String withSuffix(long count) {
        if (count < 1000) return "" + count;
        int exp = (int) (Math.log(count) / Math.log(1000));
        return String.format("%.1f%c", count / Math.pow(1000, exp), "KMGTPE".charAt(exp - 1));
    }

    public static void postDelayed(OnCompleteListener onCompleteListener, int millisecond) {
        new Handler(Looper.getMainLooper()).postDelayed(onCompleteListener::onComplete, millisecond);
    }

    @SuppressLint("SourceLockedOrientationActivity")
    public static void fullScreenMode(AppCompatActivity activity, boolean show) {
        SharedPref sharedPref = new SharedPref(activity);
        if (show) {
            setWindowFlag(activity, WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS | WindowManager.LayoutParams.FLAG_TRANSLUCENT_NAVIGATION, false);
//            if (sharedPref.getIsDarkTheme()) {
//                activity.getWindow().setNavigationBarColor(ContextCompat.getColor(activity, R.color.color_dialog_navigation_bar_dark));
//                activity.getWindow().setStatusBarColor(ContextCompat.getColor(activity, R.color.color_dialog_status_bar_dark));
//            } else {
//                activity.getWindow().setNavigationBarColor(ContextCompat.getColor(activity, R.color.color_dialog_navigation_bar_light));
//                if (Config.ENABLE_NEW_UI) {
//                    activity.getWindow().setStatusBarColor(ContextCompat.getColor(activity, R.color.color_dialog_status_bar_light));
//                } else {
//                    activity.getWindow().setStatusBarColor(ColorUtils.blendARGB(Color.BLACK, activity.getResources().getColor(R.color.color_light_status_bar), 0.6f));
//                }
//            }
        } else {
            activity.getWindow().getDecorView().setSystemUiVisibility(View.SYSTEM_UI_FLAG_VISIBLE);
            if (!sharedPref.getIsDarkTheme()) {
                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
                    if (Config.ENABLE_NEW_UI) {
                        activity.getWindow().getDecorView().setSystemUiVisibility(View.SYSTEM_UI_FLAG_LIGHT_NAVIGATION_BAR | View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR);
                    }
                }
            }
        }
    }

//    @SuppressLint("SourceLockedOrientationActivity")
//    public static void fullScreenMode(AppCompatActivity activity, boolean show) {
//        SharedPref sharedPref = new SharedPref(activity);
//        if (show) {
//            //activity.getWindow().getDecorView().setSystemUiVisibility(View.SYSTEM_UI_FLAG_LAYOUT_STABLE | View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN | View.SYSTEM_UI_FLAG_LAYOUT_HIDE_NAVIGATION);
//            setWindowFlag(activity, WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS | WindowManager.LayoutParams.FLAG_TRANSLUCENT_NAVIGATION, false);
//            int resultColor;
//            if (sharedPref.getIsDarkTheme()) {
//                resultColor = ColorUtils.blendARGB(Color.BLACK, activity.getResources().getColor(R.color.color_dark_status_bar), 0.6f);
//            } else {
//                resultColor = ColorUtils.blendARGB(Color.BLACK, activity.getResources().getColor(R.color.color_white), 0.7f);
//            }
//            activity.getWindow().setStatusBarColor(resultColor);
//            //activity.getWindow().setNavigationBarColor(Color.TRANSPARENT);
//        } else {
//            activity.getWindow().getDecorView().setSystemUiVisibility(View.SYSTEM_UI_FLAG_VISIBLE);
//            if (!sharedPref.getIsDarkTheme()) {
//                if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.O) {
//                    activity.getWindow().getDecorView().setSystemUiVisibility(View.SYSTEM_UI_FLAG_LIGHT_NAVIGATION_BAR | View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR);
//                }
//            }
//        }
//    }

    public static void setWindowFlag(Activity activity, final int bits, boolean on) {
        Window win = activity.getWindow();
        WindowManager.LayoutParams winParams = win.getAttributes();
        if (on) {
            winParams.flags |= bits;
        } else {
            winParams.flags &= ~bits;
        }
        win.setAttributes(winParams);
    }

    @SuppressLint("RtlHardcoded")
    public static void dialogButtonSelected(Activity activity, View rootView, AlertDialog alertDialog, OnPositiveButtonListener onPositiveButtonListener) {

        LinearLayout lytButton = rootView.findViewById(R.id.lyt_button);
        Button btnPositive = rootView.findViewById(R.id.btn_positive);
        Button btnNegative = rootView.findViewById(R.id.btn_negative);

        btnPositive.setOnClickListener(view -> Tools.postDelayed(() -> {
            onPositiveButtonListener.onPositive();
            alertDialog.dismiss();
        }, Constant.DELAY_ACTION_CLICK));

        btnNegative.setOnClickListener(view -> Tools.postDelayed(alertDialog::dismiss, Constant.DELAY_ACTION_CLICK));

        SharedPref sharedPref = new SharedPref(activity);
        if (sharedPref.getIsDarkTheme()) {
            btnPositive.setTextColor(ContextCompat.getColor(activity, R.color.color_white));
            btnNegative.setTextColor(ContextCompat.getColor(activity, R.color.color_white));
        } else {
            btnPositive.setTextColor(ContextCompat.getColor(activity, R.color.color_light_primary));
            btnNegative.setTextColor(ContextCompat.getColor(activity, R.color.color_light_primary));
        }

        if (Config.ENABLE_RTL_MODE) {
            lytButton.setGravity(Gravity.LEFT);
            Objects.requireNonNull(alertDialog.getWindow()).getDecorView().setLayoutDirection(View.LAYOUT_DIRECTION_RTL);
        } else {
            lytButton.setGravity(Gravity.RIGHT);
            Objects.requireNonNull(alertDialog.getWindow()).getDecorView().setLayoutDirection(View.LAYOUT_DIRECTION_LTR);
        }

    }

    @SuppressLint("RtlHardcoded")
    public static void dialogExitButtonSelected(Activity activity, View rootView, AlertDialog alertDialog, OnPositiveButtonListener onPositiveButtonListener, OnNeutralButtonListener onNeutralButtonListener) {

        LinearLayout lytButton = rootView.findViewById(R.id.lyt_button);
        Button btnPositive = rootView.findViewById(R.id.btn_positive);
        Button btnNeutral = rootView.findViewById(R.id.btn_neutral);
        Button btnNegative = rootView.findViewById(R.id.btn_negative);

        btnPositive.setOnClickListener(view -> Tools.postDelayed(() -> {
            onPositiveButtonListener.onPositive();
            alertDialog.dismiss();
        }, Constant.DELAY_ACTION_CLICK));

        btnNeutral.setOnClickListener(view -> Tools.postDelayed(() -> {
            onNeutralButtonListener.onNeutral();
            alertDialog.dismiss();
        }, Constant.DELAY_ACTION_CLICK));

        btnNegative.setOnClickListener(view -> Tools.postDelayed(alertDialog::dismiss, Constant.DELAY_ACTION_CLICK));

//        SharedPref sharedPref = new SharedPref(activity);
//        if (sharedPref.getIsDarkTheme()) {
//            btnPositive.setTextColor(ContextCompat.getColor(activity, R.color.color_white));
//            btnNeutral.setTextColor(ContextCompat.getColor(activity, R.color.color_white));
//            btnNegative.setTextColor(ContextCompat.getColor(activity, R.color.color_white));
//        } else {
//            btnPositive.setTextColor(ContextCompat.getColor(activity, R.color.color_light_primary));
//            btnNeutral.setTextColor(ContextCompat.getColor(activity, R.color.color_light_primary));
//            btnNegative.setTextColor(ContextCompat.getColor(activity, R.color.color_light_primary));
//        }

        if (Config.ENABLE_RTL_MODE) {
            lytButton.setGravity(Gravity.LEFT);
            Objects.requireNonNull(alertDialog.getWindow()).getDecorView().setLayoutDirection(View.LAYOUT_DIRECTION_RTL);
        } else {
            lytButton.setGravity(Gravity.RIGHT);
            Objects.requireNonNull(alertDialog.getWindow()).getDecorView().setLayoutDirection(View.LAYOUT_DIRECTION_LTR);
        }

    }

    public static String formatSeconds(long timeInSeconds) {
        long secondsLeft = timeInSeconds % 3600 % 60;
        long minutes = (long) (double) (timeInSeconds % 3600 / 60);
        long hours = (long) (double) (timeInSeconds / 3600);
        String HH = ((hours < 10) ? "0" : "") + hours;
        String MM = ((minutes < 10) ? "0" : "") + minutes;
        String SS = ((secondsLeft < 10) ? "0" : "") + secondsLeft;
        return HH + ":" + MM + ":" + SS;
    }

    @SuppressWarnings("deprecation")
    public static class ViewPagerAdapter extends FragmentPagerAdapter {
        private final List<Fragment> mFragmentList = new ArrayList<>();
        private final List<String> mFragmentTitleList = new ArrayList<>();

        public ViewPagerAdapter(FragmentManager manager) {
            super(manager, BEHAVIOR_RESUME_ONLY_CURRENT_FRAGMENT);
        }

        @NonNull
        @Override
        public Fragment getItem(int position) {
            return mFragmentList.get(position);
        }

        @Override
        public int getCount() {
            return mFragmentList.size();
        }

        public void addFrag(Fragment fragment, String title) {
            mFragmentList.add(fragment);
            mFragmentTitleList.add(title);
        }

        @Override
        public CharSequence getPageTitle(int position) {
            return mFragmentTitleList.get(position);
        }
    }

    public static void tintMenuIcon(Context context, MenuItem item, @ColorRes int color) {
        Drawable normalDrawable = item.getIcon();
        assert normalDrawable != null;
        Drawable wrapDrawable = DrawableCompat.wrap(normalDrawable);
        DrawableCompat.setTint(wrapDrawable, context.getResources().getColor(color));
        item.setIcon(wrapDrawable);
    }

    public static void setMargins(View view, int left, int top, int right, int bottom) {
        if (view.getLayoutParams() instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams p = (ViewGroup.MarginLayoutParams) view.getLayoutParams();
            p.setMargins(left, top, right, bottom);
            view.requestLayout();
        }
    }

}